/**
* \file: mlink_dlt.c
*
* \version: $Id:$
*
* \release: $Name:$
*
* MLINK DLT Adapter
*
* \component: mlink
*
* \author: Michael Methner ADITG/SW1 mmethner@de.adit-jv.com
*
* \copyright: (c) 2003 - 2013 ADIT Corporation
*
* \history
* 0.1 Michael Methner Initial version
*
***********************************************************************/


#include <mlink_dlt.h>
#include <mlink_common.h>

#include <endian.h>
#include <dlt/dlt.h>
#include <adit_dlt.h>

#include <stdio.h>
#include <stdlib.h>


/* PRQA: Lint Message 160, 505: deactivation because DLT macros generate this lint findings*/
/*lint -e160 -e505*/

struct mlink_dlt_context
{
  DltContext dlt_ctx;
};


DltContext * mlink_dlt_get_dlt_context(mlink_dlt_context * pContext)
{
    return &pContext->dlt_ctx;
}


mlink_dlt_context * mlink_dlt_initialize(void)
{
  mlink_dlt_context * p_dlt_context = malloc(sizeof(mlink_dlt_context));

  if(p_dlt_context)
    {
      memset(p_dlt_context,0, sizeof(mlink_dlt_context));
      DLT_REGISTER_CONTEXT(p_dlt_context->dlt_ctx,"MLCT", "MirrorLink Context");

      DLT_LOG(p_dlt_context->dlt_ctx,DLT_LOG_INFO,
          DLT_STRING("mlink_dlt: version:"), DLT_STRING(COMP_GIT_VERSION));
    }

  return p_dlt_context;
}


void mlink_dlt_finalize (mlink_dlt_context * pContext)
{
  if(pContext)
    {
      DLT_UNREGISTER_CONTEXT(pContext->dlt_ctx);
      free(pContext);
    }
}


/*
 * Mapping of errors for discovery and audio log callback
 * RealVNC                                         DLT
 * 0 - serious errors                              DLT_LOG_FATAL
 * 10 - less serious errors (usually not fatal)    DLT_LOG_ERROR
 * 20 - warnings                                   DLT_LOG_WARN
 * 30 - informational messages                     DLT_LOG_INFO
 * 100 - verbose debugging                         DLT_LOG_VERBOSE
*/
DltLogLevelType mlink_dlt_get_discovery_audiorouter_dlt_loglevel(vnc_int32_t severity)
{
  DltLogLevelType retval;

  if(severity == 0)
    {
      retval = DLT_LOG_FATAL;
    }
  else if(severity > 0 && severity <= 10)
    {
      retval = DLT_LOG_ERROR;
    }
  else if(severity > 10 && severity <= 20)
    {
      retval = DLT_LOG_WARN;
    }
  else if(severity > 20 && severity <= 30)
    {
      retval = DLT_LOG_INFO;
    }
  else
    {
      retval = DLT_LOG_VERBOSE;
    }

  return retval;
}

/*
 * Mapping of errors
 * RealVNC                                         DLT
 * 0 - serious errors                              DLT_LOG_FATAL
 * 10 - warnings                                   DLT_LOG_WARN
 * 30 - informational messages                     DLT_LOG_INFO
 * 100 - verbose debugging                         DLT_LOG_VERBOSE
*/
DltLogLevelType mlink_dlt_get_dlt_loglevel(vnc_int32_t severity)
{
  DltLogLevelType retval;

  if(severity == 0)
    {
      retval = DLT_LOG_FATAL;
    }
  else if(severity > 0 && severity <= 10)
    {
      retval = DLT_LOG_WARN;
    }
  else if(severity > 10 && severity <= 30)
    {
      retval = DLT_LOG_INFO;
    }
  else
    {
      retval = DLT_LOG_VERBOSE;
    }

  return retval;
}


void mlink_dlt_viewer_log_callback (VNCViewer *pViewer, void *pContext,
    const char *category, vnc_int32_t severity, const char *text)
{
  pViewer = pViewer;
  mlink_adapter_context * ctx = (mlink_adapter_context *)pContext;

  /*
   * Filter for VNC viewer SDK message:
   *
   * VNCViewerSDK reporting error 11 (VNCViewerErrorReset)
   *
   * Value of variable severity for this massage should be 20 (warnings)
   */

   if (severity == 0 && ((strcmp(text, "reporting error 11 (VNCViewerErrorReset)") == 0)))
    {
  	  severity = 20;
    }

  DltLogLevelType loglevel = mlink_dlt_get_dlt_loglevel(severity);
  if(ctx->dlt_ctx)
    {
      DLT_LOG(ctx->dlt_ctx->dlt_ctx,loglevel,DLT_STRING("viewer: "), DLT_STRING(category),DLT_STRING(text));
    }
}

void mlink_dlt_wifidisplay_log_callback(VNCWiFiDisplaySink *wfdSink,
                                        void *pContext,
                                        const char *category,
                                        vnc_int32_t severity,
                                        const char *text)
{
    wfdSink = wfdSink;
    mlink_adapter_context * ctx = (mlink_adapter_context *)pContext;

    DltLogLevelType loglevel = mlink_dlt_get_dlt_loglevel(severity);
    if(ctx->dlt_ctx)
      {
        DLT_LOG(ctx->dlt_ctx->dlt_ctx,loglevel,DLT_STRING("wfdsink: "), DLT_STRING(category),DLT_STRING(text));
      }
}

void  mlink_dlt_dap_log_callback(VNCDAPClient *pVNCDAPClient, void *pContext,
    const char *category, vnc_int32_t severity, const char *text)
{
  pVNCDAPClient = pVNCDAPClient;
  mlink_adapter_context * ctx = (mlink_adapter_context *)pContext;

  DltLogLevelType loglevel = mlink_dlt_get_dlt_loglevel(severity);
  if(ctx->dlt_ctx)
    {
      DLT_LOG(ctx->dlt_ctx->dlt_ctx,loglevel,DLT_STRING("dap: "), DLT_STRING(category),DLT_STRING(text));
    }
}


void mlink_dlt_cdb_log_callback(VNCCDBEndpoint *pEndpoint, void *pContext,
    const char *category, vnc_int32_t severity, const char *text)
{
  pEndpoint = pEndpoint;
  mlink_adapter_context * ctx = (mlink_adapter_context *)pContext;

  DltLogLevelType loglevel = mlink_dlt_get_dlt_loglevel(severity);
  if(ctx->dlt_ctx)
    {
      DLT_LOG(ctx->dlt_ctx->dlt_ctx,loglevel,DLT_STRING("cdb: "), DLT_STRING(category),DLT_STRING(text));
    }
}


void mlink_dlt_discovery_log_callback (void *pSDKContext, vnc_int32_t severity,
    const char *pDiscoverer, const char *pText)
{
  pDiscoverer = pDiscoverer;

  mlink_adapter_context * ctx = (mlink_adapter_context *)pSDKContext ;

  /*
   * Filter for VNC Discovery SDK messages:
   *
   * License 2200e206-f885-44f5-8cc2-2810cdb0356a added successfully.
   * License expiry date (YYYY-MM-DD): 2018-4-28
   *
   * Value of variable severity for these massages should be 30 (information messages)
   */
  if (severity == 10 && ((strcmp(pText, "License 2200e206-f885-44f5-8cc2-2810cdb0356a added successfully.") == 0) ||
		  (strcmp(pText, "License expiry date (YYYY-MM-DD): 2018-4-28") == 0)))
    {
	  severity = 30;
    }

  /*
   * Filter for VNC Discovery SDK message:
   *
   * Unable to set timer for handle before started
   * Unable to send the USB command, error 4
   * USB transfer failed to be transfered completely (0 instead of 2)
   *
   * Value of variable severity for this massage should be 20 (warnings)
   */

  if (severity == 10 && ((strcmp(pText, "Unable to set timer for handle before started") == 0) ||
		  (strcmp(pText, "Unable to send the USB command, error 4") == 0) ||
		  (strcmp(pText, "USB transfer failed to be transfered completely (0 instead of 2)") == 0)))
    {
  	  severity = 20;
    }

  DltLogLevelType loglevel = mlink_dlt_get_discovery_audiorouter_dlt_loglevel(severity);
  if(ctx->dlt_ctx)
    {
      DLT_LOG(ctx->dlt_ctx->dlt_ctx,loglevel,DLT_STRING("discovery: "),DLT_STRING(pText));
    }
}


void mlink_dlt_audiorouter_log_callback(void * pContext, vnc_int32_t severity, const char *text)
{
  mlink_adapter_context * ctx = (mlink_adapter_context *)pContext;

  DltLogLevelType loglevel = mlink_dlt_get_discovery_audiorouter_dlt_loglevel(severity);
  if(ctx->dlt_ctx)
    {
      DLT_LOG(ctx->dlt_ctx->dlt_ctx,loglevel,DLT_STRING("audiorouter: "), DLT_STRING(text));
    }
}

/*lint +e160 +e505*/
